unit maindialog;


{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls, Buttons,

  Mp3FileUtils, ID3v2Frames, contnrs;

type

  { TMainForm }

  TMainForm = class(TForm)
    eTitle: TEdit;
    eArtist: TEdit;
    eAlbum: TEdit;
    eGenre: TEdit;
    eTrack: TEdit;
    eYear: TEdit;
    eComment: TEdit;
    Image: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    lbPicture: TLabel;
    lbPicCount: TLabel;
    lbDirectory: TLabel;
    lBoxMP3: TListBox;
    lbPicInfo: TMemo;
    rbV1: TRadioButton;
    rbV2: TRadioButton;
    SelectDirectoryDialog: TSelectDirectoryDialog;
    lbUpDown:TUpDown;
    SpeedButton1: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure Label1DblClick(Sender: TObject);
    procedure lBoxMP3SelectionChange(Sender: TObject; User: boolean);
    procedure RBChange(Sender: TObject);
    procedure eUpdownClick(Sender: TObject; Button: TUDBtnType);
    procedure SpeedButton2Click(Sender: TObject);
  private
    { private declarations }
    thisTagv1: TID3v1Tag;
    thisTagV2: TID3v2Tag;
    thisMPegInfo: TMpegInfo;
    PictureFrames: TObjectList;
    procedure ClearAll;
    procedure ScanDir(DirName: TFilename);
    procedure ShowID3( Filename: string );
    procedure ShowPicture(Index: Integer);
    procedure ShowSelected;
  public
    { public declarations }
  end; 

var
  MainForm: TMainForm;

implementation


{$R *.lfm}

uses LCLProc;

const
  cTitle = 'ID3 Tag Demo for Lazarus Port of MP3FileUtils 0.6';

{ TMainForm }

procedure TMainForm.ClearAll;
begin
  eTitle.Text := '';
  eArtist.Text := '';
  eAlbum.Text := '';
  eGenre.Text := '';
  eTrack.Text := '';
  eYear.Text := '';
  eComment.Text := '';
  lbPicInfo.Clear;
  lbPicCount.Caption:='';
  Image.Picture.Assign(NIL);
end;

procedure TMainForm.ScanDir(DirName: TFilename);
var
  findResult: TSearchRec;
begin
  ClearAll;
  lbDirectory.Caption:=DirName;
  if FindFirstUTF8 ( DirName+'/*.mp3', faArchive or faReadOnly, findResult)=0 then
  repeat
    lBoxMP3.Items.Add(findResult.Name);
  until FindNextUTF8(findResult)<>0;
  FindCloseUTF8(findResult);
end;

procedure TMainForm.RBChange(Sender: TObject);
begin
  ClearAll;
  ShowSelected;
//  ShowPicture(udPicture.Position);
end;

procedure TMainForm.eUpdownClick(Sender: TObject; Button: TUDBtnType);
begin
  ShowPicture(lbUpDown.Position);
end;

procedure TMainForm.SpeedButton2Click(Sender: TObject);
begin
  ShowID3( UTF8ToSys ('C:\Dokumente und Einstellungen\Frank\Desktop\Der kleine Prinz\05 - Affenbrotbäume.mp3'));
end;

procedure TMainForm.ShowID3( Filename: string );
begin
  if rbV1.Checked then begin
    // V1 has no picture infos, hide GUI elements
    lbUpDown.Visible:=false;
    lbPicture.Visible:=false;
    lbPicCount.Visible:=false;
    Image.Visible:=false;
    lbPicInfo.Visible:=false;

    thisTagv1.ReadFromFile(Filename);
    eTitle.Text := UTF16ToUTF8(thisTagv1.Title);
    eArtist.Text := UTF16ToUTF8(thisTagv1.Artist);
    eAlbum.Text := UTF16ToUTF8(thisTagv1.Album);
    eGenre.Text := UTF16ToUTF8(thisTagv1.Genre);
    eTrack.Text := UTF16ToUTF8(thisTagv1.Track);
    eYear.Text := UTF16ToUTF8(thisTagv1.Year);
    eComment.Text := UTF16ToUTF8(thisTagv1.Comment);
  end else begin
     // V2 has  picture infos, show GUI elements
    lbUpDown.Visible:=false;
    lbPicture.Visible:=false;
    lbPicCount.Visible:=false;
    Image.Visible:=false;
    lbPicInfo.Visible:=false;

    thisTagv2.ReadFromFile(Filename);
    eTitle.Text := UTF16ToUTF8(thisTagv2.Title);
    eArtist.Text := UTF16ToUTF8(thisTagv2.Artist);
    eAlbum.Text := UTF16ToUTF8(thisTagv2.Album);
    eGenre.Text := UTF16ToUTF8(thisTagv2.Genre);
    eTrack.Text := UTF16ToUTF8(thisTagv2.Track);
    eYear.Text := UTF16ToUTF8(thisTagv2.Year);
    eComment.Text:= UTF16ToUTF8(thisTagV2.Comment);

    PictureFrames := thisTagv2.GetAllPictureFrames;
    // show arrows only if there is more than one picture
    lbUpDown.Visible:= PictureFrames.Count>1;
    // show picture info only if a picture is available
    lbPicture.Visible:=PictureFrames.Count<>0;
    lbPicCount.Visible:=PictureFrames.Count<>0;
    Image.Visible:=PictureFrames.Count<>0;
    lbPicInfo.Visible:=PictureFrames.Count<>0;

    if PictureFrames.Count > 0 then begin;
      lbUpDown.Min:=0;
      lbUpDown.Max:=PictureFrames.Count-1;
    end;
    ShowPicture(0);   // show 1st picture
  end;
  thisMPegInfo.LoadFromFile(Filename);
  if (thisMPegInfo.Duration mod 60) < 10 then begin
    lbPicInfo.Lines.Add(IntToStr(thisMPegInfo.Duration div 60) + ':0' + IntToStr(thisMPegInfo.Duration mod 60));
  end else begin
    lbPicInfo.Lines.Add(IntToStr(thisMPegInfo.Duration div 60) + ':' + IntToStr(thisMPegInfo.Duration mod 60));
  end;
end;

procedure TMainForm.ShowPicture(Index: Integer);
var PictureDescription: UnicodeString;
    PictureMime: AnsiString;
    PictureData: TStream;
    PictureType: Byte;
    JPGImage: TJPEGImage;
begin
  lbPicCount.Caption:='';
  if Index<PictureFrames.Count then begin
    PictureData := TMemoryStream.Create;
    TID3v2Frame(PictureFrames[Index]).GetPicture(PictureMime, PictureType, PictureDescription, PictureData);
    PictureData.Seek(0, soFromBeginning);
    JPGImage := TJPEGImage.Create;
    try
      try
        JPGImage.LoadFromStream(PictureData);
//        JPGImage.DIBNeeded;
        Image.Picture.Bitmap.Assign(JPGImage);
      except
        Image.Picture.Assign(NIL);
      end;
    finally
      JPGImage.Free;
    end;
    lbPicCount.Caption:=IntToStr(Index+1)+'/'+IntToStr(PictureFrames.Count);
    lbPicInfo.Clear;
    lbPicInfo.Lines.Add( IntToStr(Image.Picture.Height)+'*'+IntToStr(Image.Picture.Width));
    if PictureDescription <> '' then begin
      lbPicInfo.Lines.Add(PictureDescription);
    end;
    PictureData.Free;
  end else begin
     Image.Picture.Assign(NIL);
  end;
end;

procedure TMainForm.ShowSelected;
var
  i: integer;
begin
  if lBoxMP3.SelCount <> 0 then begin
      for i := 0 to lBoxMP3.Count-1 do begin
         if lBoxMP3.Selected[i] then begin
           ShowID3(UTF8ToSys(lbDirectory.Caption+ '/' + lBoxMP3.Items[i]));
         end;
      end;
    end;
end;

procedure TMainForm.Label1DblClick(Sender: TObject);
begin
  if SelectDirectoryDialog.Execute then begin
    ClearAll;
    lBoxMP3.Clear;
    ScanDir(SelectDirectoryDialog.FileName);
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.Title:=cTitle;
  Caption := cTitle;
  thisTagv1 := TID3v1Tag.Create;
  thisTagv2 := TID3v2Tag.Create;
  thisMPegInfo := TMpegInfo.Create;
  lbUpDown.OnClick := @eUpdownClick;
  ClearAll;
end;

procedure TMainForm.lBoxMP3SelectionChange(Sender: TObject; User: boolean);
begin
  ShowSelected;
end;

end.

