//
//    MeMP - Mein Einfacher Mp3-Player
//
//    (c) Dezember 2007, Daniel 'Gausi' Gaumann
//        www.gausi.de, mail@gausi.de
//
//    Du kannst diesen Quellcode ohne Einschrnkung -
//    unverndert oder auch modifiziert in eigenen
//    Projekten verwenden.
//
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, 
  AudioDatei_Klasse, Playlist_Klasse, XPMan;

type
  TForm1 = class(TForm)
    BtnPlayPause: TButton;
    BtnStop: TButton;
    MainScrollbar: TScrollBar;
    LblTitel: TLabel;
    LblTime: TLabel;
    MainTimer: TTimer;
    VolumeScrollbar: TScrollBar;
    FilesOpenDialog: TOpenDialog;
    PlaylistView: TListView;
    BtnAddFiles: TButton;
    BtnPrev: TButton;
    BtnNext: TButton;
    BtnLoadList: TButton;
    PlaylistOpenDialog: TOpenDialog;
    BtnClear: TButton;
    SpectrumPaintbox: TPaintBox;
    XPManifest1: TXPManifest;
    BtnSaveList: TButton;
    PlaylistSaveDialog: TSaveDialog;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BtnPlayPauseClick(Sender: TObject);
    procedure BtnStopClick(Sender: TObject);
    procedure BtnPrevClick(Sender: TObject);
    procedure BtnNextClick(Sender: TObject);
    procedure BtnAddFilesClick(Sender: TObject);
    procedure BtnLoadListClick(Sender: TObject);
    procedure BtnSaveListClick(Sender: TObject);
    procedure BtnClearClick(Sender: TObject);

    procedure MainTimerTimer(Sender: TObject);
    procedure MainScrollbarScroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure VolumeScrollbarScroll(Sender: TObject;
      ScrollCode: TScrollCode; var ScrollPos: Integer);
    procedure PlaylistViewDblClick(Sender: TObject);
    procedure PlaylistViewCustomDrawItem(Sender: TCustomListView;
      Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);

    procedure OnMeMPEndFile(Sender: TObject);
    procedure OnMeMPPlay(Sender: TObject);
    procedure OnMeMPPause(Sender: TObject);
    procedure OnMeMPStop(Sender: TObject);
    procedure OnMeMPChange(Sender: TObject);
    procedure OnPlaylistAddItem(Sender: TObject; NewAudioFile: TAudioFile);
    procedure OnPlaylistClear(Sender: TObject);

  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  MeMPPlaylist: TMeMPPlaylist;

Const
  // BASS_ChannelIsActive return values
  BASS_ACTIVE_STOPPED = 0;
  BASS_ACTIVE_PLAYING = 1;
  BASS_ACTIVE_STALLED = 2;
  BASS_ACTIVE_PAUSED  = 3;
  
implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  MeMPPlaylist := TMeMPPlaylist.Create;
  MeMPPlaylist.InitBassEngine(Handle);
  MeMPPlaylist.InitPlugins(ExtractFileDir(ParamStr(0)));
  MeMPPlaylist.Volume := 100;
  MeMPPlaylist.InitSpectrum(SpectrumPaintbox.Width, SpectrumPaintbox.Height);
  MeMPPlaylist.OnEndFile := OnMeMPEndFile;
  MeMPPlaylist.OnPlay   := OnMeMPPlay;
  MeMPPlaylist.OnPause  := OnMeMPPause;
  MeMPPlaylist.OnResume := OnMeMPPlay;
  MeMPPlaylist.OnStop   := OnMeMPStop ;
  MeMPPlaylist.OnChange := OnMeMPChange;
  MeMPPlaylist.OnAddItem  := OnPlaylistAddItem;
  MeMPPlaylist.OnClear    := OnPlaylistClear;
  FilesOpenDialog.Filter := MeMPPlaylist.Filter;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  MeMPPlaylist.Free;
end;

// ================================================
// Einfache Steuerbuttons. Play, Stop, Vor, Zurck
// ================================================
procedure TForm1.BtnPlayPauseClick(Sender: TObject);
begin
  case MeMPPlaylist.BassStatus of
    BASS_ACTIVE_STOPPED: MeMPPlaylist.Play(-1);
    BASS_ACTIVE_PLAYING: MeMPPlaylist.Pause;
    BASS_ACTIVE_PAUSED : MeMPPlaylist.Resume;
  end;
end;

procedure TForm1.BtnStopClick(Sender: TObject);
begin
  MeMPPlaylist.Stop;
end;

procedure TForm1.BtnPrevClick(Sender: TObject);
begin
  MeMPPlaylist.PlayPrevious;
end;

procedure TForm1.BtnNextClick(Sender: TObject);
begin
  MeMPPlaylist.PlayNext;
end;

// ================================================
// Scrollbars: Position und Lautsrke
// ================================================
procedure TForm1.MainScrollbarScroll(Sender: TObject;
  ScrollCode: TScrollCode; var ScrollPos: Integer);
begin
  if  ScrollCode = scEndScroll	then
  begin
    MeMPPlaylist.Progress := Scrollpos / 100;
    MainScrollbar.Tag := 0;
  end else
    MainScrollbar.Tag := 1;
end;

procedure TForm1.VolumeScrollbarScroll(Sender: TObject;
  ScrollCode: TScrollCode; var ScrollPos: Integer);
begin
  MeMPPlaylist.Volume := (100 - Scrollpos) / 100;
end;

// ================================================
// Playlist-Steuerung
// ================================================
procedure TForm1.BtnAddFilesClick(Sender: TObject);
var i: Integer;
begin
  if FilesOpenDialog.Execute then
    for i := 0 to FilesOpenDialog.Files.Count - 1 do
      MeMPPlaylist.Add(FilesOpenDialog.Files[i]);
end;

procedure TForm1.BtnLoadListClick(Sender: TObject);
begin
  if PlaylistOpenDialog.Execute then
    MeMPPlaylist.LoadFromFile(PlaylistOpenDialog.FileName);
end;

procedure TForm1.BtnSaveListClick(Sender: TObject);
begin
  if PlaylistSaveDialog.Execute then
    MeMPPlaylist.SaveToFile(PlaylistSaveDialog.FileName);
end;

procedure TForm1.BtnClearClick(Sender: TObject);
begin
  MeMPPlaylist.Clear;
end;

procedure TForm1.PlaylistViewDblClick(Sender: TObject);
begin
  MeMPPlaylist.Play(PlaylistView.ItemIndex);
end;

// ================================================
// Playingfile fett zeichnen
// ================================================
procedure TForm1.PlaylistViewCustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  If TAudioFile(Item.Data) = MeMPPlaylist.PlayingFile then
    PlaylistView.Canvas.Font.Style := [fsBold];
end;

// ================================================
// Timer - regelmig neue Vis zeichnen und Pos aktualisieren
// ================================================
procedure TForm1.MainTimerTimer(Sender: TObject);
var t: integer;
begin
  if MainScrollbar.Tag = 0 then
    MainScrollbar.Position := Round(MeMPPlaylist.Progress * 100);
  t := Round(MeMPPlaylist.Time);
  LblTime.Caption := Format('%.2d:%.2d',[t Div 60, t Mod 60]);
  MeMPPlaylist.DrawSpectrum(SpectrumPaintbox.Canvas.Handle);
end;

// ================================================
// Events
// ================================================
procedure TForm1.OnMeMPPlay(Sender: TObject);
begin
  MainTimer.Enabled := True;
  BtnPlayPause.Caption := 'Pause';
  PlaylistView.Refresh;
end;

procedure TForm1.OnMeMPPause(Sender: TObject);
begin
  MainTimer.Enabled := False;
  BtnPlayPause.Caption := 'Weiter';
  PlaylistView.Refresh;
end;

procedure TForm1.OnMeMPStop(Sender: TObject);
begin
  MainTimer.Enabled := False;
  BtnPlayPause.Caption := 'Play';
  PlaylistView.Refresh;
end;

procedure TForm1.OnMeMPEndFile(Sender: TObject);
begin
  MeMPPlaylist.PlayNext;
end;

procedure TForm1.OnMeMPChange(Sender: TObject);
begin
  LblTitel.Caption := (Sender as TMeMPPlaylist).PlaylistTitel;
end;

procedure TForm1.OnPlaylistAddItem(Sender: TObject; NewAudioFile: TAudioFile);
var newItem: TListItem;
    t: Integer;
begin
  newItem := PlaylistView.Items.Add;
  newItem.Caption := NewAudioFile.PlaylistTitel;
  t := NewAudioFile.Dauer;
  NewItem.SubItems.Add(Format('%d:%.2d',[t Div 60, t Mod 60]));
  NewItem.Data := NewAudioFile;
end;

procedure TForm1.OnPlaylistClear(Sender: TObject);
begin
  PlaylistView.Clear;
end;

end.
