unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ApproxStrUtils;

type
  TForm1 = class(TForm)
    GrpBoxInput: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    TBError: TTrackBar;
    LblError: TLabel;
    GrpBoxOutput: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    LblApproxDistance: TLabel;
    LblApproxResemblesText: TLabel;
    LblApproxContainsStr: TLabel;
    LblApproxContainsText: TLabel;
    LblApproxBestAppearance: TLabel;
    LblApproxPos: TLabel;
    LblApproxPosEx: TLabel;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure TBErrorChange(Sender: TObject);
    procedure Label3Click(Sender: TObject);
    procedure Label4Click(Sender: TObject);
    procedure Label5Click(Sender: TObject);
    procedure Label6Click(Sender: TObject);
    procedure Label8Click(Sender: TObject);
    procedure Label7Click(Sender: TObject);
    procedure Label9Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  LblError.Caption := 'Max. Fehler: ' + IntToStr(TBError.Position);
  Label3Click(NIL);
  Label4Click(NIL);
  Label5Click(NIL);
  Label6Click(NIL);
  Label7Click(NIL);
  Label8Click(NIL);
  Label9Click(NIL);
end;

procedure TForm1.TBErrorChange(Sender: TObject);
begin
  LblError.Caption := 'Max. Fehler: ' + IntToStr(TBError.Position);
end;

procedure TForm1.Label3Click(Sender: TObject);
begin
    LblApproxDistance.Caption := IntToStr(ApproxDistance(Edit1.Text, Edit2.Text));
end;

procedure TForm1.Label4Click(Sender: TObject);
begin
  if ApproxResemblesText(Edit1.Text, Edit2.Text, TBError.Position) then
    LblApproxResemblesText.Caption := 'Ja'
  else
    LblApproxResemblesText.Caption := 'Nein';
end;

procedure TForm1.Label5Click(Sender: TObject);
begin
  if ApproxContainsStr(Edit1.Text, Edit2.Text, TBError.Position) then
    LblApproxContainsStr.Caption := 'Ja'
  else
    LblApproxContainsStr.Caption := 'Nein';
end;

procedure TForm1.Label6Click(Sender: TObject);
begin
  if ApproxContainsText(Edit1.Text, Edit2.Text, TBError.Position) then
    LblApproxContainsText.Caption := 'Ja'
  else
    LblApproxContainsText.Caption := 'Nein';
end;

procedure TForm1.Label8Click(Sender: TObject);
var c, err, i: Integer;
    s: string;
begin
  i := ApproxBestAppearance(Edit1.Text, Edit2.Text, c, err);
  s := copy(Edit1.Text, i, c);
  LblApproxBestAppearance.Caption :=
      Format('Position %d, Fehler %d, Vorkommen: %s',[i, err, s]);
end;

procedure TForm1.Label7Click(Sender: TObject);
var i, c: Integer;
    s: string;
begin
  i := ApproxPos(Edit1.Text, Edit2.Text, c, TBError.Position);

  if i <> 0 then
  begin
    s := copy(Edit1.Text, i, c);
    LblApproxPos.Caption :=
      Format('Position %d, Vorkommen: %s',[i, s]);
  end else
    LblApproxPos.Caption := 'Kein Vorkommen gefunden';
end;

procedure TForm1.Label9Click(Sender: TObject);
var c, i: Integer;
    s: string;
begin
  i := 0;
  LblApproxPosEx.Caption := '';
  repeat
    i := ApproxPosEx(Edit1.Text, Edit2.Text, i+1, c, TBError.Position);
    if i <> 0 then
    begin
      s := copy(Edit1.Text, i, c);
      LblApproxPosEx.Caption := LblApproxPosEx.Caption + Format('Position %d, Vorkommen: %s',[i, s]) + #13#10;
    end;
  until i = 0;
  LblApproxPosEx.Caption := LblApproxPosEx.Caption + 'Keine weiteren Vorkommen gefunden';
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Label3Click(NIL);
  Label4Click(NIL);
  Label5Click(NIL);
  Label6Click(NIL);
  Label7Click(NIL);
  Label8Click(NIL);
  Label9Click(NIL);
end;

end.
